/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.service;

import com.atlassian.seraph.SecurityService;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.CachedPathMapper;
import com.atlassian.seraph.util.PathMapper;
import com.atlassian.seraph.util.XMLUtils;
import com.opensymphony.util.ClassLoaderUtil;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.LRUMap;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PathService
implements SecurityService {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$seraph$service$PathService == null ? (class$com$atlassian$seraph$service$PathService = PathService.class$("com.atlassian.seraph.service.PathService")) : class$com$atlassian$seraph$service$PathService));
    static String CONFIG_FILE_PARAM_KEY = "config.file";
    String configFileLocation = "seraph-paths.xml";
    private PathMapper pathMapper = new CachedPathMapper((Map)new LRUMap(10), (Map)new LRUMap(10));
    private Map paths = new HashMap();
    static /* synthetic */ Class class$com$atlassian$seraph$service$PathService;

    public void init(Map params, SecurityConfig config) {
        try {
            if (params.get(CONFIG_FILE_PARAM_KEY) != null) {
                this.configFileLocation = (String)params.get(CONFIG_FILE_PARAM_KEY);
            }
            this.configurePathMapper();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configurePathMapper() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = ClassLoaderUtil.getResource((String)this.configFileLocation, this.getClass());
            if (fileUrl == null) {
                fileUrl = ClassLoaderUtil.getResource((String)("/" + this.configFileLocation), this.getClass());
            }
            if (fileUrl == null) {
                return;
            }
            Document doc = factory.newDocumentBuilder().parse(fileUrl.toString());
            Element root = doc.getDocumentElement();
            NodeList pathNodes = root.getElementsByTagName("path");
            for (int i = 0; i < pathNodes.getLength(); ++i) {
                Element path = (Element)pathNodes.item(i);
                String pathName = path.getAttribute("name");
                String roleNames = XMLUtils.getContainedText(path, "role-name");
                String urlPattern = XMLUtils.getContainedText(path, "url-pattern");
                if (roleNames == null || urlPattern == null) continue;
                String[] rolesArr = this.parseRoles(roleNames);
                this.paths.put(pathName, rolesArr);
                this.pathMapper.put(pathName, urlPattern);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    protected String[] parseRoles(String roleNames) {
        StringTokenizer st = new StringTokenizer(roleNames, ",; \t\n", false);
        String[] roles = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            roles[i] = st.nextToken();
            ++i;
        }
        return roles;
    }

    public void destroy() {
    }

    public Set getRequiredRoles(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return this.getRequiredRoles(servletPath);
    }

    public Set getRequiredRoles(String servletPath) {
        HashSet<String> requiredRoles = new HashSet<String>();
        Collection constraintMatches = this.pathMapper.getAll(servletPath);
        if (constraintMatches == null) {
            throw new RuntimeException("No constraints matched for path " + servletPath);
        }
        Iterator iterator = constraintMatches.iterator();
        while (iterator.hasNext()) {
            String constraint = (String)iterator.next();
            String[] rolesForPath = (String[])this.paths.get(constraint);
            for (int i = 0; i < rolesForPath.length; ++i) {
                if (requiredRoles.contains(rolesForPath[i])) continue;
                requiredRoles.add(rolesForPath[i]);
            }
        }
        return requiredRoles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

