/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.config.SecurityConfig;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class SecurityHttpRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request;
    private SecurityConfig securityConfig;

    public SecurityHttpRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String getRemoteUser() {
        Principal user = this.getUserPrincipal();
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    public Principal getUserPrincipal() {
        if (this.securityConfig == null) {
            this.securityConfig = (SecurityConfig)this.request.getSession().getServletContext().getAttribute("seraph_config");
        }
        Principal user = this.securityConfig.getAuthenticator().getUser(this.request);
        return user;
    }
}

