/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.filter.SecurityHttpRequestWrapper;
import com.atlassian.seraph.interceptor.LoginInterceptor;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class LoginFilter
implements Filter {
    private FilterConfig config = null;
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$seraph$filter$LoginFilter == null ? (class$com$atlassian$seraph$filter$LoginFilter = LoginFilter.class$("com.atlassian.seraph.filter.LoginFilter")) : class$com$atlassian$seraph$filter$LoginFilter));
    public static final String ALREADY_FILTERED = "loginfilter.already.filtered";
    public static final String LOGIN_SUCCESS = "success";
    public static final String LOGIN_FAILED = "failed";
    public static final String LOGIN_ERROR = "error";
    public static final String LOGIN_NOATTEMPT = null;
    public static final String OS_AUTHSTATUS_KEY = "os_authstatus";
    private SecurityConfig securityConfig = null;
    static /* synthetic */ Class class$com$atlassian$seraph$filter$LoginFilter;
    static /* synthetic */ Class class$com$atlassian$seraph$interceptor$LoginInterceptor;

    public void init(FilterConfig config) {
        this.config = config;
    }

    public void destroy() {
        this.config = null;
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if ((req = new SecurityHttpRequestWrapper((HttpServletRequest)req)).getAttribute(ALREADY_FILTERED) != null || !this.getSecurityConfig().getController().isSecurityEnabled()) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        req.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_NOATTEMPT);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String username = request.getParameter("os_username");
        String password = request.getParameter("os_password");
        boolean persistentLogin = "true".equals(request.getParameter("os_cookie"));
        boolean loggedIn = false;
        if (username != null && password != null) {
            LoginInterceptor loginInterceptor;
            Iterator iterator;
            List interceptors = this.getSecurityConfig().getInterceptors(class$com$atlassian$seraph$interceptor$LoginInterceptor == null ? (class$com$atlassian$seraph$interceptor$LoginInterceptor = LoginFilter.class$("com.atlassian.seraph.interceptor.LoginInterceptor")) : class$com$atlassian$seraph$interceptor$LoginInterceptor);
            log.debug((Object)"Username and Password are not null - processing login request");
            try {
                iterator = interceptors.iterator();
                while (iterator.hasNext()) {
                    loginInterceptor = (LoginInterceptor)iterator.next();
                    loginInterceptor.beforeLogin(request, response, username, password, persistentLogin);
                }
                loggedIn = this.getAuthenticator().login(request, response, username, password, persistentLogin);
                if (loggedIn) {
                    log.debug((Object)"Login was successful - setting attribute to \"Success\"");
                    request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_SUCCESS);
                } else {
                    log.debug((Object)"Login was not successful - setting attribute to \"Failed\"");
                    request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_FAILED);
                }
            }
            catch (AuthenticatorException e) {
                log.debug((Object)"Login was not successful, and exception was thrown - setting attribute to \"Error\"");
                request.setAttribute(OS_AUTHSTATUS_KEY, (Object)LOGIN_ERROR);
                e.printStackTrace();
                log.warn((Object)("Exception was thrown whilst logging in: " + e.getMessage()), (Throwable)e);
            }
            iterator = interceptors.iterator();
            while (iterator.hasNext()) {
                loginInterceptor = (LoginInterceptor)iterator.next();
                loginInterceptor.afterLogin(request, response, username, password, persistentLogin, (String)request.getAttribute(OS_AUTHSTATUS_KEY));
            }
        }
        if (loggedIn) {
            String url;
            String originalURL = (String)request.getSession().getAttribute(this.getSecurityConfig().getOriginalURLKey());
            if (originalURL != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged In - Redirecting to Original URL: " + request.getContextPath() + originalURL));
                }
                request.getSession().setAttribute(this.getSecurityConfig().getOriginalURLKey(), null);
                url = RedirectUtils.appendPathToContext(request.getContextPath(), originalURL);
                response.sendRedirect(url);
                return;
            }
            if (request.getParameter("os_destination") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged In - redirecting to os_destination: " + request.getContextPath() + request.getParameter("os_destination")));
                }
                url = RedirectUtils.appendPathToContext(request.getContextPath(), request.getParameter("os_destination"));
                response.sendRedirect(url);
                return;
            }
        }
        chain.doFilter(req, res);
    }

    protected Authenticator getAuthenticator() {
        return this.getSecurityConfig().getAuthenticator();
    }

    protected SecurityConfig getSecurityConfig() {
        if (this.securityConfig == null) {
            this.securityConfig = (SecurityConfig)this.config.getServletContext().getAttribute("seraph_config");
        }
        return this.securityConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

