/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.auth;

import com.atlassian.seraph.auth.AbstractAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.interceptor.LogoutInterceptor;
import com.atlassian.seraph.util.CookieUtils;
import com.atlassian.seraph.util.RedirectUtils;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.ejb.util.Base64;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class DefaultAuthenticator
extends AbstractAuthenticator {
    private String loginCookieKey;
    private String authType;
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$seraph$auth$DefaultAuthenticator == null ? (class$com$atlassian$seraph$auth$DefaultAuthenticator = DefaultAuthenticator.class$("com.atlassian.seraph.auth.DefaultAuthenticator")) : class$com$atlassian$seraph$auth$DefaultAuthenticator));
    public static String LOGGED_IN_KEY = "seraph_defaultauthenticator_user";
    public static String LOGGED_OUT_KEY = "seraph_defaultauthenticator_logged_out_user";
    private static int AUTOLOGIN_COOKIE_AGE = 31536000;
    static /* synthetic */ Class class$com$atlassian$seraph$auth$DefaultAuthenticator;
    static /* synthetic */ Class class$com$atlassian$seraph$interceptor$LogoutInterceptor;

    public void init(Map params, SecurityConfig config) {
        log.debug((Object)(this.getClass().getName() + " $Revision: 1950 $ initializing"));
        super.init(params, config);
        this.loginCookieKey = config.getLoginCookieKey();
        this.authType = config.getAuthType();
    }

    public boolean isUserInRole(HttpServletRequest request, String role) {
        return this.getRoleMapper().hasRole(this.getUser(request), request, role);
    }

    public boolean login(HttpServletRequest request, HttpServletResponse response, String username, String password, boolean cookie) throws AuthenticatorException {
        Principal user = this.getUser(username);
        if (user == null) {
            log.info((Object)("Cannot login user '" + username + "' as they do not exist."));
        } else {
            boolean authenticated = this.authenticate(user, password);
            if (authenticated) {
                request.getSession().setAttribute(LOGGED_IN_KEY, (Object)user);
                request.getSession().setAttribute(LOGGED_OUT_KEY, null);
                if (this.getRoleMapper().canLogin(user, request)) {
                    if (cookie && response != null) {
                        CookieUtils.setCookie(request, response, this.getLoginCookieKey(), this.encodeCookie(username, password), AUTOLOGIN_COOKIE_AGE, this.getCookiePath(request));
                    }
                    return true;
                }
                request.getSession().removeAttribute(LOGGED_IN_KEY);
            } else {
                log.info((Object)("Cannot login user '" + username + "' as they used an incorrect password"));
            }
        }
        if (response != null && CookieUtils.getCookie(request, this.getLoginCookieKey()) != null) {
            log.warn((Object)("User: " + username + " tried to login but they do not have USE permission or weren't found. Deleting cookie."));
            try {
                CookieUtils.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
            }
            catch (Exception e) {
                log.error((Object)("Could not invalidate cookie: " + e), (Throwable)e);
            }
        }
        return false;
    }

    protected RoleMapper getRoleMapper() {
        return SecurityConfigFactory.getInstance().getRoleMapper();
    }

    protected Principal getUser(String username) {
        try {
            return UserManager.getInstance().getUser(username);
        }
        catch (EntityNotFoundException e) {
            log.debug((Object)("Could not find user who tried to login: " + (Object)((Object)e)));
            return null;
        }
    }

    protected boolean authenticate(Principal user, String password) {
        return ((User)user).authenticate(password);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        LogoutInterceptor interceptor;
        List interceptors = this.getLogoutInterceptors();
        Iterator iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            interceptor = (LogoutInterceptor)iterator.next();
            interceptor.beforeLogout(request, response);
        }
        request.getSession().setAttribute(LOGGED_IN_KEY, null);
        request.getSession().setAttribute(LOGGED_OUT_KEY, (Object)Boolean.TRUE);
        try {
            CookieUtils.invalidateCookie(request, response, this.getLoginCookieKey(), this.getCookiePath(request));
        }
        catch (Exception e) {
            log.error((Object)("Could not invalidate cookie: " + e), (Throwable)e);
        }
        iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            interceptor = (LogoutInterceptor)iterator.next();
            interceptor.afterLogout(request, response);
        }
        return true;
    }

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal basicAuthUser;
        if (request.getSession(false) != null) {
            Principal sessionUser = this.getUserFromSession(request);
            if (sessionUser != null) {
                return sessionUser;
            }
        } else {
            Principal cookieUser = this.getUserFromCookie(request, response);
            if (cookieUser != null) {
                return cookieUser;
            }
            log.debug((Object)"Cannot log user in via a cookie");
        }
        if (RedirectUtils.isBasicAuthentication(request, this.authType) && (basicAuthUser = this.getUserFromBasicAuthentication(request, response)) != null) {
            return basicAuthUser;
        }
        return null;
    }

    private Principal getUserFromCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = CookieUtils.getCookie(request, this.getLoginCookieKey());
        if (cookie == null) {
            return null;
        }
        String[] values = this.decodeCookie(cookie.getValue());
        if (values == null) {
            return null;
        }
        String username = values[0];
        String password = values[1];
        log.debug((Object)"Got username and password from cookie, attempting to authenticate user");
        try {
            if (!this.login(request, response, username, password, false)) {
                return null;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Cookie login failed with exception: " + e), (Throwable)e);
            return null;
        }
        log.debug((Object)"Logged user in via a cookie");
        return this.getUserFromSession(request);
    }

    private Principal getUserFromSession(HttpServletRequest request) {
        try {
            if (request.getSession().getAttribute(LOGGED_OUT_KEY) != null) {
                log.debug((Object)"Session found; user has already logged out");
                return null;
            }
            if (request.getSession().getAttribute(LOGGED_IN_KEY) == null) {
                return null;
            }
            log.debug((Object)"Session found; user already logged in");
            return (Principal)request.getSession().getAttribute(LOGGED_IN_KEY);
        }
        catch (Exception e) {
            log.warn((Object)("Exception when retrieving user from session: " + e), (Throwable)e);
            return null;
        }
    }

    private Principal getUserFromBasicAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String header = request.getHeader("Authorization");
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decode((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            try {
                if (this.login(request, response, username, password, false)) {
                    log.debug((Object)"Logged in via basic auth");
                    return this.getUser(username);
                }
            }
            catch (AuthenticatorException e) {
                log.debug((Object)("Exception trying to login via basic auth:" + e), (Throwable)e);
            }
            try {
                response.sendError(401);
            }
            catch (IOException e) {
                log.warn((Object)("Exception trying to send basic auth failed error: " + e), (Throwable)e);
            }
            return null;
        }
        if (response == null) {
            return null;
        }
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "BASIC realm=\"protected-area\"");
        return null;
    }

    protected String getCookiePath(HttpServletRequest request) {
        String path = request.getContextPath();
        if (path == null || path.equals("")) {
            return "/";
        }
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    protected String getLoginCookieKey() {
        return this.loginCookieKey;
    }

    protected List getLogoutInterceptors() {
        return this.getConfig().getInterceptors(class$com$atlassian$seraph$interceptor$LogoutInterceptor == null ? (class$com$atlassian$seraph$interceptor$LogoutInterceptor = DefaultAuthenticator.class$("com.atlassian.seraph.interceptor.LogoutInterceptor")) : class$com$atlassian$seraph$interceptor$LogoutInterceptor);
    }

    protected String encodeCookie(String username, String password) {
        return CookieUtils.encodePasswordCookie(username, password, this.getConfig().getCookieEncoding());
    }

    protected String[] decodeCookie(String value) {
        return CookieUtils.decodePasswordCookie(value, this.getConfig().getCookieEncoding());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

