/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.velocity.VelocityManager;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public class DefaultVelocityManager
implements VelocityManager {
    private VelocityEngine ve;
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$velocity$DefaultVelocityManager == null ? (class$com$atlassian$velocity$DefaultVelocityManager = DefaultVelocityManager.class$("com.atlassian.velocity.DefaultVelocityManager")) : class$com$atlassian$velocity$DefaultVelocityManager));
    static /* synthetic */ Class class$com$atlassian$velocity$DefaultVelocityManager;

    public DefaultVelocityManager() {
        try {
            this.ve = new VelocityEngine();
            Properties props = new Properties();
            try {
                props.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", this.getClass()));
            }
            catch (Exception e) {
                ((Hashtable)props).put("resource.loader", "class");
                ((Hashtable)props).put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                ((Hashtable)props).put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            }
            this.ve.init(props);
        }
        catch (Exception e) {
            log.error((Object)("Exception initialising Velocity: " + e), (Throwable)e);
        }
    }

    public String getBody(String templateDirectory, String template, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, null, null, contextParameters);
    }

    public String getBody(String templateDirectory, String template, String baseurl, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, baseurl, null, contextParameters);
    }

    public String getEncodedBody(String templateDirectory, String template, String encoding, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, null, encoding, contextParameters);
    }

    public String getEncodedBody(String templateDirectory, String template, String baseurl, String encoding, Map contextParameters) throws VelocityException {
        if (template == null) {
            throw new VelocityException("Trying to send mail with no template.");
        }
        URL templateUrl = ClassLoaderUtils.getResource((String)(templateDirectory + template), this.getClass());
        if (templateUrl == null) {
            throw new VelocityException("Could not find template '" + templateDirectory + template + "' ensure it is in the classpath.");
        }
        try {
            VelocityContext context = this.createVelocityContext(baseurl, contextParameters);
            StringWriter writer = new StringWriter();
            if (encoding == null) {
                this.ve.mergeTemplate(templateDirectory + template, (Context)context, (Writer)writer);
            } else {
                this.ve.mergeTemplate(templateDirectory + template, encoding, (Context)context, (Writer)writer);
            }
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)("Exception getting message body from Velocity: " + e), (Throwable)e);
            return "An error occurred whilst rendering this message.  Please contact the administrators, and inform them of this bug.\n\nDetails:\n-------\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private VelocityContext createVelocityContext(String baseurl, Map contextParameters) {
        VelocityContext context = new VelocityContext(){

            public Object put(String key, Object value) {
                if (key == null) {
                    return null;
                }
                return this.internalPut(key, value);
            }
        };
        if (baseurl != null) {
            context.put("baseurl", (Object)baseurl);
        }
        context.put("formatter", (Object)this.getDateFormat());
        if (contextParameters != null) {
            Iterator params = contextParameters.keySet().iterator();
            while (params.hasNext()) {
                String key = (String)params.next();
                context.put(key, contextParameters.get(key));
            }
        }
        return context;
    }

    public String getEncodedBodyForContent(String content, String baseurl, Map contextParameters) throws VelocityException {
        if (content == null) {
            throw new VelocityException("Trying to send mail with no content.");
        }
        try {
            VelocityContext context = this.createVelocityContext(baseurl, contextParameters);
            StringWriter writer = new StringWriter();
            this.ve.evaluate((Context)context, (Writer)writer, "getEncodedBodyFromContent", content);
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)("Exception getting message body from Velocity: " + e), (Throwable)e);
            return "An error occurred whilst rendering this message.  Please contact the administrators, and inform them of this bug.\n\nDetails:\n-------\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("EEE, d MMM yyyy h:mm a");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

