/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util.thumbnail;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Category;

public class Thumber {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$core$util$thumbnail$Thumber == null ? (class$com$atlassian$core$util$thumbnail$Thumber = Thumber.class$("com.atlassian.core.util.thumbnail.Thumber")) : class$com$atlassian$core$util$thumbnail$Thumber));
    private ImageInfo imageInfo = new ImageInfo();
    public static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String GIF_MIME_TYPE = "image/gif";
    public static final List THUMBNAIL_MIME_TYPES = new ArrayList(3);
    public static final String JPEG_FORMAT = "JPEG";
    public static final String PNG_FORMAT = "PNG";
    public static final String GIF_FORMAT = "GIF";
    public static final List THUMBNAIL_FORMATS = new ArrayList(3);
    private float encodingQuality = 0.8f;
    static /* synthetic */ Class class$com$atlassian$core$util$thumbnail$Thumber;

    public boolean checkToolkit() {
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable e) {
            log.error((Object)"Unable to acquire AWT default toolkit - thumbnails will not be displayed. Check DISPLAY variable or use setting -Djava.awt.headless=true.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Thumbnail retrieveOrCreateThumbNail(File originalFile, File thumbnailFile, int maxWidth, int maxHeight, long attachmentId) throws MalformedURLException {
        FileInputStream originalFileStream = null;
        originalFileStream = new FileInputStream(originalFile);
        Thumbnail thumbnail = this.retrieveOrCreateThumbNail(originalFileStream, originalFile.getName(), thumbnailFile, maxWidth, maxHeight, attachmentId);
        Object var10_9 = null;
        try {
            originalFileStream.close();
        }
        catch (IOException e2) {
            log.warn((Object)e2, (Throwable)e2);
        }
        return thumbnail;
        catch (FileNotFoundException e) {
            try {
                log.error((Object)("Unable to create thumbnail: file not found: " + originalFile.getAbsolutePath()));
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    originalFileStream.close();
                }
                catch (IOException e2) {
                    log.warn((Object)e2, (Throwable)e2);
                }
                throw throwable;
            }
            try {
                originalFileStream.close();
            }
            catch (IOException e2) {
                log.warn((Object)e2, (Throwable)e2);
            }
        }
        return null;
    }

    public Thumbnail retrieveOrCreateThumbNail(InputStream originalFileStream, String fileName, File thumbnailFile, int maxWidth, int maxHeight, long attachmentId) throws MalformedURLException {
        Thumbnail thumbnail = this.getThumbnail(thumbnailFile, fileName, attachmentId);
        if (thumbnail == null) {
            try {
                thumbnail = this.createThumbnail(originalFileStream, thumbnailFile, maxWidth, maxHeight, attachmentId, fileName);
            }
            catch (Throwable e) {
                log.error((Object)("Unable to create thumbnail image of attachment with id:" + attachmentId), e);
                return null;
            }
        }
        return thumbnail;
    }

    private BufferedImage scaleImage(Image originalImage, int maxWidth, int maxHeight) {
        WidthHeightHelper widthHeightHelper = this.determineScaleSize(maxWidth, maxHeight, originalImage);
        BufferedImage thumbnailImage = new BufferedImage(widthHeightHelper.getWidth(), widthHeightHelper.getHeight(), 1);
        Graphics2D graphics2D = thumbnailImage.createGraphics();
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHints(hints);
        graphics2D.setBackground(Color.white);
        graphics2D.fillRect(0, 0, widthHeightHelper.getWidth(), widthHeightHelper.getHeight());
        graphics2D.drawImage(originalImage, 0, 0, widthHeightHelper.getWidth(), widthHeightHelper.getHeight(), null);
        return thumbnailImage;
    }

    private WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, Image image) {
        return this.determineScaleSize(maxWidth, maxHeight, image.getWidth(null), image.getHeight(null));
    }

    private Thumbnail createThumbnail(InputStream originalFile, File thumbnailFile, int maxWidth, int maxHeight, long thumbId, String fileName) throws IOException, FileNotFoundException {
        Image originalImage = this.getImage(originalFile);
        BufferedImage scaledImage = this.scaleImage(originalImage, maxWidth, maxHeight);
        int height = scaledImage.getHeight();
        int width = scaledImage.getWidth();
        this.storeThumbImage(scaledImage, thumbnailFile);
        return new Thumbnail(height, width, fileName, thumbId);
    }

    private Thumbnail getThumbnail(File thumbnailFile, String filename, long thumbId) throws MalformedURLException {
        if (thumbnailFile.exists()) {
            Image thumbImage = this.getImage(thumbnailFile);
            return new Thumbnail(thumbImage.getHeight(null), thumbImage.getWidth(null), filename, thumbId);
        }
        return null;
    }

    public Image getImage(File file) throws MalformedURLException {
        Image image = Toolkit.getDefaultToolkit().getImage(this.getUrl(file));
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            log.error((Object)("Unsuccessful attempt to load image with fileName: " + file.getName()), (Throwable)e);
        }
        return image;
    }

    private URL getUrl(File file) throws MalformedURLException {
        try {
            return file.toURI().toURL();
        }
        catch (NoSuchMethodError e) {
            return file.toURL();
        }
    }

    public Image getImage(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        byte[] buf = new byte[1024];
        while ((i = is.read(buf)) != -1) {
            out.write(buf, 0, i);
        }
        byte[] fileBytes = out.toByteArray();
        Image image = Toolkit.getDefaultToolkit().createImage(fileBytes);
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            log.error((Object)"Unsuccessful attempt to load image input stream from webdav", (Throwable)e);
        }
        return image;
    }

    public void setEncodingQuality(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("Invalid quality setting '" + f + "', value must be between 0 and 1. ");
        }
        this.encodingQuality = f;
    }

    private void storeThumbImage(BufferedImage scaledImage, File thumbnailFile) throws FileNotFoundException {
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(thumbnailFile));
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fout);
        JPEGEncodeParam encodeParams = encoder.getDefaultJPEGEncodeParam(scaledImage);
        encodeParams.setQuality(this.encodingQuality, false);
        encoder.setJPEGEncodeParam(encodeParams);
        try {
            encoder.encode(scaledImage);
            ((OutputStream)fout).close();
        }
        catch (IOException e) {
            log.error((Object)"Error encoding the thumbnail image of attachment.", (Throwable)e);
        }
    }

    public WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, int imageWidth, int imageHeight) {
        if (maxHeight > imageHeight && maxWidth > imageWidth) {
            return new WidthHeightHelper(imageWidth, imageHeight);
        }
        double thumbRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            return new WidthHeightHelper(maxWidth, (int)((double)maxWidth / imageRatio));
        }
        return new WidthHeightHelper((int)((double)maxHeight * imageRatio), maxHeight);
    }

    public boolean isFileSupportedImage(File file) {
        try {
            return this.isFileSupportedImage(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileSupportedImage(InputStream inputStream) {
        boolean bl;
        try {
            this.imageInfo.setInput(inputStream);
            this.imageInfo.check();
            bl = THUMBNAIL_FORMATS.contains(this.imageInfo.getFormatName());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        THUMBNAIL_MIME_TYPES.add(JPEG_MIME_TYPE);
        THUMBNAIL_MIME_TYPES.add(PNG_MIME_TYPE);
        THUMBNAIL_MIME_TYPES.add(GIF_MIME_TYPE);
        THUMBNAIL_FORMATS.add(JPEG_FORMAT);
        THUMBNAIL_FORMATS.add(PNG_FORMAT);
        THUMBNAIL_FORMATS.add(GIF_FORMAT);
    }

    public static class WidthHeightHelper {
        private int width;
        private int height;

        public WidthHeightHelper(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

