/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.user;

import com.atlassian.core.user.UserUtils;
import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Category;

public class GroupUtils {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$core$user$GroupUtils == null ? (class$com$atlassian$core$user$GroupUtils = GroupUtils.class$("com.atlassian.core.user.GroupUtils")) : class$com$atlassian$core$user$GroupUtils));
    static /* synthetic */ Class class$com$atlassian$core$user$GroupUtils;

    public static Group getGroupSafely(String name) throws ImmutableException {
        Group group = null;
        try {
            group = UserManager.getInstance().getGroup(name);
        }
        catch (EntityNotFoundException e) {
            try {
                group = UserManager.getInstance().createGroup(name);
            }
            catch (DuplicateEntityException e1) {
                e.printStackTrace(System.err);
            }
        }
        return group;
    }

    public static Group getGroup(String name) {
        if (name == null) {
            return null;
        }
        if (GroupUtils.existsGroup(name)) {
            try {
                return UserManager.getInstance().getGroup(name);
            }
            catch (EntityNotFoundException e) {
                log.error((Object)("Error getting group: " + name), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static boolean existsGroup(String name) {
        try {
            UserManager.getInstance().getGroup(name);
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        return true;
    }

    public static Collection getGroups() {
        return UserManager.getInstance().getGroups();
    }

    public static void removeGroup(Group group) throws Exception {
        HashSet users = new HashSet(group.getUsers());
        Iterator iterator = users.iterator();
        while (iterator.hasNext()) {
            try {
                User u = UserUtils.getUser((String)iterator.next());
                u.removeFromGroup(group);
            }
            catch (EntityNotFoundException entityNotFoundException) {}
        }
        group.remove();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

