/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.DefaultTaskQueue;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorQueuedTaskQueue
extends DefaultTaskQueue {
    private static final transient Log logger = LogFactory.getLog((Class)(class$com$atlassian$core$task$ErrorQueuedTaskQueue == null ? (class$com$atlassian$core$task$ErrorQueuedTaskQueue = ErrorQueuedTaskQueue.class$("com.atlassian.core.task.ErrorQueuedTaskQueue")) : class$com$atlassian$core$task$ErrorQueuedTaskQueue));
    private TaskQueue errorQueue;
    private int retryCount = 5;
    private List failed;
    static /* synthetic */ Class class$com$atlassian$core$task$ErrorQueuedTaskQueue;

    public ErrorQueuedTaskQueue() {
        this(new DefaultTaskQueue());
    }

    public ErrorQueuedTaskQueue(TaskQueue errorQueue) {
        this.errorQueue = errorQueue;
    }

    public void flush() {
        this.failed = new ArrayList();
        super.flush();
        Iterator iterator = this.failed.iterator();
        while (iterator.hasNext()) {
            this.addTask((Task)iterator.next());
        }
    }

    protected void handleException(Task task, Exception rootException) {
        TaskDecorator theTask = (TaskDecorator)task;
        if (theTask.getExecutionCount() > this.retryCount) {
            this.errorQueue.addTask(theTask.getTask());
        } else {
            this.failed.add(task);
        }
        if (rootException instanceof MessagingException) {
            Exception e = rootException;
            while (e instanceof MessagingException) {
                MessagingException me = (MessagingException)e;
                logger.error((Object)me.getMessage(), (Throwable)me);
                e = me.getNextException();
            }
        } else {
            logger.error((Object)rootException, (Throwable)rootException);
        }
    }

    public void addTask(Task task) {
        if (task instanceof TaskDecorator) {
            super.addTask(task);
        } else {
            super.addTask(new TaskDecorator(task));
        }
    }

    public TaskQueue getErrorQueue() {
        return this.errorQueue;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TaskDecorator
    implements Task {
        private Task task;
        private int executionCount = 0;

        public TaskDecorator(Task task) {
            this.task = task;
        }

        public void execute() throws Exception {
            ++this.executionCount;
            this.task.execute();
        }

        public int getExecutionCount() {
            return this.executionCount;
        }

        public Task getTask() {
            return this.task;
        }
    }
}

