/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import java.sql.Timestamp;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTaskQueue
implements TaskQueue {
    private static final transient Log logger = LogFactory.getLog((Class)(class$com$atlassian$core$task$DefaultTaskQueue == null ? (class$com$atlassian$core$task$DefaultTaskQueue = DefaultTaskQueue.class$("com.atlassian.core.task.DefaultTaskQueue")) : class$com$atlassian$core$task$DefaultTaskQueue));
    protected Buffer items = BufferUtils.synchronizedBuffer((Buffer)new UnboundedFifoBuffer());
    private boolean flushing;
    private Timestamp flushStarted;
    static /* synthetic */ Class class$com$atlassian$core$task$DefaultTaskQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        block8: {
            if (this.flushing) {
                return;
            }
            this.flushing = true;
            this.flushStarted = new Timestamp(System.currentTimeMillis());
            block5: while (true) {
                while (!this.items.isEmpty()) {
                    Task task = (Task)this.items.remove();
                    logger.debug((Object)("Executing: " + task));
                    try {
                        task.execute();
                        continue block5;
                    }
                    catch (Exception e) {
                        this.handleException(task, e);
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.flushing = false;
                this.flushStarted = null;
            }
        }
    }

    protected void handleException(Task task, Exception e) {
        logger.error((Object)("Failed to execute task : " + task), (Throwable)e);
    }

    public int size() {
        return this.items.size();
    }

    public void addTask(Task task) {
        logger.debug((Object)("Queued: " + task));
        this.items.add((Object)task);
    }

    public Buffer getQueue() {
        return this.items;
    }

    public boolean isFlushing() {
        return this.flushing;
    }

    public Timestamp getFlushStarted() {
        return this.flushStarted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

