/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.filters.gzip;

import com.atlassian.core.filters.AbstractFilter;
import com.atlassian.core.filters.gzip.GzipResponseWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public abstract class GzipFilter
extends AbstractFilter {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$core$filters$gzip$GzipFilter == null ? (class$com$atlassian$core$filters$gzip$GzipFilter = GzipFilter.class$("com.atlassian.core.filters.gzip.GzipFilter")) : class$com$atlassian$core$filters$gzip$GzipFilter));
    private static final String ALREADY_FILTERED = (class$com$atlassian$core$filters$gzip$GzipFilter == null ? (class$com$atlassian$core$filters$gzip$GzipFilter = GzipFilter.class$("com.atlassian.core.filters.gzip.GzipFilter")) : class$com$atlassian$core$filters$gzip$GzipFilter).getName() + "_already_filtered";
    static /* synthetic */ Class class$com$atlassian$core$filters$gzip$GzipFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        if (req instanceof HttpServletRequest && this.useGzipForThisRequest((HttpServletRequest)req)) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            if (ae != null && ae.indexOf("gzip") != -1) {
                log.debug((Object)"GZIP supported, compressing.");
                GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(response, this.getEncoding());
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                return;
            }
            chain.doFilter(req, res);
        } else {
            chain.doFilter(req, res);
        }
    }

    protected boolean useGzipForThisRequest(HttpServletRequest req) {
        return this.useGzip() && !this.isStyleSheet(req) && this.isTopLevelRequest(req);
    }

    protected abstract boolean useGzip();

    protected boolean isTopLevelRequest(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.include.servlet_path") == null;
    }

    protected boolean isStyleSheet(HttpServletRequest request) {
        return request.getServletPath() != null && request.getServletPath().indexOf("css") != -1;
    }

    protected abstract String getEncoding();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

