/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.filters;

import com.atlassian.core.filters.AbstractFilter;
import com.atlassian.core.util.StringUtils;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class AbstractEncodingFilter
extends AbstractFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding(this.getEncoding());
        servletResponse.setContentType(this.getContentType());
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            if (this.isNonCachableUri(req)) {
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store,  must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
        }
        filterChain.doFilter((ServletRequest)new WordCurlyQuotesRequestWrapper(servletRequest), (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)servletResponse){

            public void setContentType(String s) {
                if (s == null || s.length() <= "text/html".length() || s.charAt(0) != 't' || !s.startsWith("text/html")) {
                    if (s != null && s.trim().length() == "text/html".length() && s.charAt(0) == 't' && s.startsWith("text/html")) {
                        String currentCharSet = this.getResponse().getCharacterEncoding();
                        s = s + ";charset=" + currentCharSet;
                    }
                    super.setContentType(s);
                }
            }

            public void setHeader(String string, String string1) {
                if (!this.isContentLocationHeader(string)) {
                    super.setHeader(string, string1);
                }
            }

            public void addHeader(String string, String string1) {
                if (!this.isContentLocationHeader(string)) {
                    super.addHeader(string, string1);
                }
            }

            private boolean isContentLocationHeader(String headerName) {
                return headerName != null && "content-location".equalsIgnoreCase(headerName);
            }
        });
    }

    public void init(FilterConfig filterConfig) {
    }

    protected boolean isNonCachableUri(HttpServletRequest req) {
        String uri = TextUtils.noNull((String)req.getRequestURI());
        return uri.indexOf(".jsp") > 0 || uri.indexOf(".jspa") > 0;
    }

    protected abstract String getEncoding();

    protected abstract String getContentType();

    private class WordCurlyQuotesRequestWrapper
    extends HttpServletRequestWrapper {
        private Map parameterValueCache = new HashMap();
        private Map parameterMap = null;

        public WordCurlyQuotesRequestWrapper(ServletRequest servletRequest) {
            super((HttpServletRequest)servletRequest);
        }

        public String getParameter(String string) {
            return this.escapeString(super.getParameter(string));
        }

        protected String escapeString(String string) {
            return StringUtils.escapeCP1252(string, AbstractEncodingFilter.this.getEncoding());
        }

        public Map getParameterMap() {
            if (this.parameterMap == null) {
                this.parameterMap = new HashMap();
                Map originalMap = super.getParameterMap();
                Iterator i = originalMap.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.parameterMap.put(key, this.getParameterValues(key));
                }
            }
            return this.parameterMap;
        }

        public String[] getParameterValues(String string) {
            String[] returnValue = (String[])this.parameterValueCache.get(string);
            if (returnValue == null) {
                String[] parameterValues = super.getParameterValues(string);
                if (parameterValues == null) {
                    return null;
                }
                for (int i = 0; i < parameterValues.length; ++i) {
                    String parameterValue;
                    parameterValues[i] = parameterValue = this.escapeString(parameterValues[i]);
                }
                this.parameterValueCache.put(string, parameterValues);
                returnValue = parameterValues;
            }
            return returnValue;
        }
    }
}

