/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.named.IQNamed;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.CData;
import electric.xml.Comment;
import electric.xml.Elements;
import electric.xml.INamespaceContext;
import electric.xml.IXPath;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import electric.xml.Selection;
import electric.xml.Text;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class Element
extends Parent
implements IQNamed,
INamespaceContext,
org.w3c.dom.Element {
    String prefix;
    String namespace;
    String name;
    private NodeList attributes = new NodeList();

    public Element() {
        this.name = "UNDEFINED";
    }

    public Element(String string) {
        this.name = string;
    }

    public Element(String string, String string2, String string3) {
        this.prefix = string;
        this.name = string2;
        this.namespace = string3;
    }

    public Element(Element element) {
        super(element);
        this.namespace = element.namespace;
        this.name = element.name;
        Attribute attribute = (Attribute)element.attributes.first;
        while (attribute != null) {
            this.attributes.append(new Attribute(attribute));
            attribute = (Attribute)attribute.next;
        }
        if (this.namespace != null) {
            this.prefix = this.getPrefix(this.namespace, element.prefix);
        }
    }

    public Object clone() {
        return new Element(this);
    }

    public Element getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public Element getParentElement() {
        return (Element)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public String getQName() {
        if (this.namespace == null) {
            return this.name;
        }
        if (this.namespace.endsWith(":")) {
            return this.namespace + this.name;
        }
        return this.namespace + ":" + this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPrefix(String string) {
        return this.getPrefix(string, null);
    }

    public String getPrefix(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        String string3 = this.getNamespacePrefix(string);
        if (string3 != null) {
            return string3;
        }
        Element element = this.getRoot();
        if (string2 == null || this.getNamespace(string2) != null) {
            string2 = "n" + element.getAttributeObjects().size();
        }
        element.setNamespace(string2, string);
        return string2;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Element setName(String string) {
        this.name = string;
        this.namespace = this.getDefaultNamespace();
        return this;
    }

    public Element setName(String string, String string2) throws NamespaceException {
        this.prefix = string;
        this.name = string2;
        if (string == null || string == "") {
            this.namespace = this.getDefaultNamespace();
        } else {
            this.namespace = this.getNamespace(string);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + string);
            }
        }
        return this;
    }

    public void setName(String string, String string2, String string3) {
        this.prefix = string;
        this.name = string2;
        this.namespace = string3;
    }

    public String getQName(String string) throws NamespaceException {
        int n = string.indexOf(58);
        String string2 = null;
        if (n != -1) {
            String string3 = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = this.getNamespace(string3);
            if (string2 == null) {
                throw new NamespaceException("could not resolve " + string3 + ":" + string);
            }
        } else {
            string2 = this.getDefaultNamespace();
        }
        if (string2 == null) {
            return string;
        }
        if (string2.endsWith(":")) {
            return string2 + string;
        }
        return string2 + ":" + string;
    }

    public boolean hasName(String string, String string2) {
        if (!this.name.equals(string2)) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(string);
    }

    public boolean hasName(String string) {
        return this.name.equals(string);
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public Text getText() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Text) {
                return (Text)node;
            }
            node = node.next;
        }
        return null;
    }

    public Text getText(String string) {
        Element element = this.getElement(string);
        return element == null ? null : element.getText();
    }

    public Text getText(String string, String string2) {
        Element element = this.getElement(string, string2);
        return element == null ? null : element.getText();
    }

    public Text getText(IXPath iXPath) {
        Element element = this.getElement(iXPath);
        return element == null ? null : element.getText();
    }

    public String getTextString() {
        Text text = this.getText();
        return text == null ? null : text.string;
    }

    public String getTextString(String string) {
        Text text = this.getText(string);
        return text == null ? null : text.string;
    }

    public String getTextString(String string, String string2) {
        Text text = this.getText(string, string2);
        return text == null ? null : text.string;
    }

    public String getTextString(IXPath iXPath) {
        Text text = this.getText(iXPath);
        return text == null ? null : text.string;
    }

    public String getTrimTextString() {
        Text text = this.getText();
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(String string) {
        Text text = this.getText(string);
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(String string, String string2) {
        Text text = this.getText(string, string2);
        return text == null ? null : text.string.trim();
    }

    public String getTrimTextString(IXPath iXPath) {
        Text text = this.getText(iXPath);
        return text == null ? null : text.string.trim();
    }

    public Element setText(String string) {
        return this.setText(string == null ? null : new Text(string));
    }

    public void setText(String string, String string2) {
        this.setElement(string).setText(string2);
    }

    public void setText(String string, String string2, String string3) {
        this.setElement(string, string2).setText(string3);
    }

    public Element setText(Text text) {
        Text text2 = this.getText();
        if (text == null) {
            if (text2 != null) {
                text2.remove();
            }
        } else if (text2 == null) {
            this.addChild(text);
        } else {
            text2.replaceWith(text);
        }
        return this;
    }

    public Element addText(String string) {
        return this.addText(new Text(string));
    }

    public Element addText(Text text) {
        this.addChild(text);
        return this;
    }

    public Element insertText(String string) {
        return this.insertText(new Text(string));
    }

    public Element insertText(Text text) {
        this.insertChild(text);
        return this;
    }

    public String getString() {
        Text text = this.getText();
        return text == null ? null : text.string.trim();
    }

    public String getString(String string) {
        Text text = this.getText(string);
        return text == null ? null : text.string.trim();
    }

    public String getString(String string, String string2) {
        Text text = this.getText(string, string2);
        return text == null ? null : text.string.trim();
    }

    public void setString(String string) {
        this.setText(string);
    }

    public void setString(String string, String string2) {
        this.setElement(string).setText(string2);
    }

    public void setString(String string, String string2, String string3) {
        this.setElement(string, string2).setText(string3);
    }

    public boolean getBoolean() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing boolean value");
        }
        if (string.equalsIgnoreCase("true") || string.equals("1") || string.equals("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equals("0") || string.equals("no")) {
            return false;
        }
        throw new NumberFormatException("invalid value for the boolean argument. expected \"true\" or \"false\", but received - " + string);
    }

    public boolean getBoolean(String string) throws NumberFormatException {
        return this.needElement(string).getBoolean();
    }

    public boolean getBoolean(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getBoolean();
    }

    public void setBoolean(boolean bl) {
        this.setText(bl ? "true" : "false");
    }

    public void setBoolean(String string, boolean bl) {
        this.setElement(string).setBoolean(bl);
    }

    public void setBoolean(String string, String string2, boolean bl) {
        this.setElement(string, string2).setBoolean(bl);
    }

    public byte getByte() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing byte value");
        }
        return Byte.parseByte(string);
    }

    public byte getByte(String string) throws NumberFormatException {
        return this.needElement(string).getByte();
    }

    public byte getByte(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getByte();
    }

    public void setByte(byte by) {
        this.setText(Byte.toString(by));
    }

    public void setByte(String string, byte by) {
        this.setElement(string).setByte(by);
    }

    public void setByte(String string, String string2, byte by) {
        this.setElement(string, string2).setByte(by);
    }

    public char getChar() throws NumberFormatException {
        return (char)this.getShort();
    }

    public char getChar(String string) throws NumberFormatException {
        return (char)this.getShort(string);
    }

    public char getChar(String string, String string2) throws NumberFormatException {
        return (char)this.getShort(string, string2);
    }

    public void setChar(char c) {
        this.setShort((short)c);
    }

    public void setChar(String string, char c) {
        this.setShort(string, (short)c);
    }

    public void setChar(String string, String string2, char c) {
        this.setShort(string, string2, (short)c);
    }

    public short getShort() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing short value");
        }
        return Short.parseShort(string);
    }

    public short getShort(String string) throws NumberFormatException {
        return this.needElement(string).getShort();
    }

    public short getShort(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getShort();
    }

    public void setShort(short s) {
        this.setText(Short.toString(s));
    }

    public void setShort(String string, short s) {
        this.setElement(string).setShort(s);
    }

    public void setShort(String string, String string2, short s) {
        this.setElement(string, string2).setShort(s);
    }

    public int getInt() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing int value");
        }
        return Integer.parseInt(string);
    }

    public int getInt(String string) throws NumberFormatException {
        return this.needElement(string).getInt();
    }

    public int getInt(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getInt();
    }

    public void setInt(int n) {
        this.setText(Integer.toString(n));
    }

    public void setInt(String string, int n) {
        this.setElement(string).setInt(n);
    }

    public void setInt(String string, String string2, int n) {
        this.setElement(string, string2).setInt(n);
    }

    public long getLong() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing long value");
        }
        return Long.parseLong(string);
    }

    public long getLong(String string) throws NumberFormatException {
        return this.needElement(string).getLong();
    }

    public long getLong(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getLong();
    }

    public void setLong(long l) {
        this.setText(Long.toString(l));
    }

    public void setLong(String string, long l) {
        this.setElement(string).setLong(l);
    }

    public void setLong(String string, String string2, long l) {
        this.setElement(string, string2).setLong(l);
    }

    public float getFloat() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing float value");
        }
        if ("NaN".equals(string)) {
            return Float.NaN;
        }
        if ("INF".equals(string)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string)) {
            return Float.NEGATIVE_INFINITY;
        }
        return new Float(string).floatValue();
    }

    public float getFloat(String string) throws NumberFormatException {
        return this.needElement(string).getFloat();
    }

    public float getFloat(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getFloat();
    }

    public void setFloat(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            this.setText("INF");
        } else if (f == Float.NEGATIVE_INFINITY) {
            this.setText("-INF");
        } else {
            this.setText(Float.toString(f));
        }
    }

    public void setFloat(String string, float f) {
        this.setElement(string).setFloat(f);
    }

    public void setFloat(String string, String string2, float f) {
        this.setElement(string, string2).setFloat(f);
    }

    public double getDouble() throws NumberFormatException {
        String string = this.getString();
        if (string == null) {
            throw new NumberFormatException("missing double value");
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        return new Double(string);
    }

    public double getDouble(String string) throws NumberFormatException {
        return this.needElement(string).getDouble();
    }

    public double getDouble(String string, String string2) throws NumberFormatException {
        return this.needElement(string, string2).getDouble();
    }

    public void setDouble(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            this.setText("INF");
        } else if (d == Double.NEGATIVE_INFINITY) {
            this.setText("-INF");
        } else {
            this.setText(Double.toString(d));
        }
    }

    public void setDouble(String string, double d) {
        this.setElement(string).setDouble(d);
    }

    public void setDouble(String string, String string2, double d) {
        this.setElement(string, string2).setDouble(d);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public Attributes getAttributeObjects() {
        return new Attributes(this.attributes);
    }

    public Attribute getAttributeObject(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.name.equals(string)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttributeObject(String string, String string2) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.hasName(string, string2)) {
                return attribute;
            }
            attribute = (Attribute)attribute.next;
        }
        return null;
    }

    public Attribute getAttributeObject(IXPath iXPath) {
        return iXPath.getAttribute(this);
    }

    public Attributes getAttributes(IXPath iXPath) {
        return iXPath.getAttributes(this);
    }

    public String getAttributeValue(String string) {
        Attribute attribute = this.getAttributeObject(string);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(String string, String string2) {
        Attribute attribute = this.getAttributeObject(string, string2);
        return attribute == null ? null : attribute.value;
    }

    public String getAttributeValue(IXPath iXPath) {
        Attribute attribute = this.getAttributeObject(iXPath);
        return attribute == null ? null : attribute.value;
    }

    public void setAttribute(String string, String string2) {
        this.setAttribute(new Attribute(string, string2));
    }

    public Element setAttribute(String string, String string2, String string3) {
        this.setAttribute(new Attribute(string, string2, string3));
        return this;
    }

    public Element setAttribute(Attribute attribute) throws NamespaceException {
        attribute.resolve(this);
        Attribute attribute2 = (Attribute)this.attributes.first;
        while (attribute2 != null) {
            if (attribute2.hasName(attribute.namespace, attribute.name)) {
                this.attributes.replace(attribute2, attribute);
                return this;
            }
            attribute2 = (Attribute)attribute2.next;
        }
        this.attributes.append(attribute);
        return this;
    }

    public void removeAttribute(String string) {
        Attribute attribute = this.getAttributeObject(string);
        if (attribute != null) {
            attribute.remove();
        }
    }

    public Attribute removeAttribute(String string, String string2) {
        Attribute attribute = this.getAttributeObject(string, string2);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attribute removeAttribute(IXPath iXPath) {
        Attribute attribute = this.getAttributeObject(iXPath);
        if (attribute != null) {
            attribute.remove();
        }
        return attribute;
    }

    public Attributes removeAttributes(IXPath iXPath) {
        Attributes attributes = this.getAttributes(iXPath);
        attributes.remove();
        attributes.reset();
        return attributes;
    }

    public Element setNextSibling(String string) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string);
        this.setNextSiblingChild(element);
        return element;
    }

    public Element setNextSibling(String string, String string2) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string, string2);
        this.setNextSiblingChild(element);
        return element;
    }

    public Element setNextSibling(Element element) {
        element.setParent(this.parent);
        this.setNextSiblingChild(element);
        return element;
    }

    public Element setPreviousSibling(String string) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string);
        this.setPreviousSiblingChild(element);
        return element;
    }

    public Element setPreviousSibling(String string, String string2) {
        Element element = new Element();
        element.setParent(this.parent);
        element.setName(string, string2);
        this.setPreviousSiblingChild(element);
        return element;
    }

    public Element setPreviousSibling(Element element) {
        element.setParent(this.parent);
        this.setPreviousSiblingChild(element);
        return element;
    }

    public Dictionary getNamespaces() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                hashtable.put(attribute.name, attribute.value);
            }
            attribute = (Attribute)attribute.next;
        }
        return hashtable;
    }

    public String getNamespace(String string) {
        if (string.length() == 0) {
            string = "xmlns";
        }
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(string)) {
                String string2 = attribute.value;
                return string2.length() > 0 ? string2 : null;
            }
            attribute = (Attribute)attribute.next;
        }
        return this.parent == null ? null : this.parent.getNamespace(string);
    }

    public String getDefaultNamespace() {
        return this.getNamespace("xmlns");
    }

    public String getNamespacePrefix(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.value.equals(string)) {
                return attribute.name;
            }
            attribute = (Attribute)attribute.next;
        }
        if (this.parent != null) {
            return this.parent.getNamespacePrefix(string);
        }
        return null;
    }

    public String[] getNamespacePrefixes(String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.addNamespacePrefixes(string, vector, vector2);
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    protected void addNamespacePrefixes(String string, Vector vector, Vector vector2) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace) {
                if (attribute.value.equals(string) && !vector.contains(attribute.name)) {
                    vector2.addElement(attribute.name);
                }
                vector.addElement(attribute.name);
            }
            attribute = (Attribute)attribute.next;
        }
        if (this.parent != null) {
            this.parent.addNamespacePrefixes(string, vector, vector2);
        }
    }

    public void setNamespace(String string, String string2) throws NamespaceException {
        this.setAttribute(new Attribute(string, string2, true));
    }

    public boolean removeNamespace(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isNamespace && attribute.name.equals(string)) {
                attribute.remove();
                return true;
            }
            attribute = (Attribute)attribute.next;
        }
        return false;
    }

    public synchronized Element getElementWithId(String string) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isId && attribute.value.equals(string)) {
                return this;
            }
            attribute = (Attribute)attribute.next;
        }
        return super.getElementWithId(string);
    }

    public Hashtable getIds() {
        Hashtable hashtable = new Hashtable();
        this.addIds(hashtable);
        return hashtable;
    }

    synchronized void addIds(Hashtable hashtable) {
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            if (attribute.isId) {
                hashtable.put(attribute.value, this);
            }
            attribute = (Attribute)attribute.next;
        }
        super.addIds(hashtable);
    }

    public int size() {
        int n = 0;
        Node node = this.attributes.first;
        while (node != null) {
            n += 1 + node.size();
            node = node.next;
        }
        if (this.children.isEmpty()) {
            n = this.prefix == null ? (n += 3 + this.name.length()) : (n += 3 + this.prefix.length() + 1 + this.name.length());
        } else {
            n = this.prefix == null ? (n += this.name.length() * 2 + 5) : (n += (this.prefix.length() + 1 + this.name.length()) * 2 + 5);
            Node node2 = this.children.first;
            while (node2 != null) {
                n += node2.size();
                node2 = node2.next;
            }
        }
        return n;
    }

    public void read(NodeReader nodeReader) throws IOException, NamespaceException {
        nodeReader.read();
        this.name = nodeReader.readToken();
        if (nodeReader.peek() == 58) {
            this.prefix = this.name;
            nodeReader.read();
            this.name = nodeReader.readToken();
        }
        nodeReader.skipWhitespace();
        int n = nodeReader.peek();
        if (n != 62 && n != 47) {
            this.readAttributes(nodeReader);
        }
        if (this.prefix == null) {
            this.namespace = this.getDefaultNamespace();
        } else {
            this.namespace = this.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + this.prefix);
            }
        }
        int n2 = nodeReader.read();
        if (n2 == 47) {
            nodeReader.readChar(62);
        } else {
            String string;
            if (n2 != 62) {
                throw new IOException("expected > or /");
            }
            this.readChildren(nodeReader);
            nodeReader.readChar(60);
            nodeReader.readChar(47);
            if (this.prefix != null) {
                string = nodeReader.readToken();
                if (!this.prefix.equals(string)) {
                    throw new IOException("<" + this.prefix + ":...> does not match </" + string + ":...>");
                }
                nodeReader.readChar(58);
            }
            string = nodeReader.readToken();
            nodeReader.readChar(62);
            if (!this.name.equals(string)) {
                throw new IOException("<..." + this.name + "> does not match </..." + string + ">");
            }
        }
    }

    public void readAttributes(NodeReader nodeReader) throws IOException, NamespaceException {
        Attribute attribute;
        int n = 0;
        do {
            attribute = new Attribute();
            nodeReader.read(attribute);
            this.attributes.append(attribute);
            nodeReader.skipWhitespace();
        } while ((n = nodeReader.peek()) != 62 && n != 47);
        attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            attribute.resolve(this);
            attribute = (Attribute)attribute.next;
        }
    }

    public void readChildren(NodeReader nodeReader) throws IOException, NamespaceException {
        while (true) {
            StringBuffer stringBuffer = nodeReader.readWhitespace();
            nodeReader.mark(2);
            int n = nodeReader.peekRead();
            int n2 = nodeReader.peekRead();
            nodeReader.reset();
            if (n == -1) break;
            if (n != 60) {
                nodeReader.read(new Text(this));
                continue;
            }
            if (n2 == 47) {
                if (stringBuffer == null || nodeReader.isStrip() && !this.children.isEmpty()) break;
                nodeReader.read(new Text(this));
                break;
            }
            if (stringBuffer != null && !nodeReader.isStrip()) {
                new Text(this).setString(stringBuffer.toString());
            }
            if (n2 == 33 && nodeReader.peekString("<![CDATA[")) {
                nodeReader.read(new CData(this));
                continue;
            }
            if (n2 == 33 && nodeReader.peekString("<!--")) {
                nodeReader.read(new Comment(this));
                continue;
            }
            if (n2 == 63) {
                nodeReader.read(new Instruction(this));
                continue;
            }
            Element element = new Element();
            this.addChild(element);
            nodeReader.read(element);
        }
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        nodeWriter.writeIndent();
        nodeWriter.write('<');
        if (this.prefix != null && !this.prefix.equals("")) {
            nodeWriter.write(this.prefix);
            nodeWriter.write(':');
        }
        nodeWriter.write(this.name);
        Attribute attribute = (Attribute)this.attributes.first;
        while (attribute != null) {
            nodeWriter.write(' ');
            nodeWriter.write(attribute);
            attribute = (Attribute)attribute.next;
        }
        if (this.children.isEmpty()) {
            if (nodeWriter.getExpandEmptyElements()) {
                nodeWriter.write("></");
                if (this.prefix != null && !this.prefix.equals("")) {
                    nodeWriter.write(this.prefix);
                    nodeWriter.write(':');
                }
                nodeWriter.write(this.name);
                nodeWriter.write('>');
            } else {
                nodeWriter.write("/>");
            }
        } else {
            nodeWriter.write('>');
            this.writeChildren(nodeWriter);
            nodeWriter.write("</");
            if (this.prefix != null && !this.prefix.equals("")) {
                nodeWriter.write(this.prefix);
                nodeWriter.write(':');
            }
            nodeWriter.write(this.name);
            nodeWriter.write('>');
        }
    }

    public void writeChildren(NodeWriter nodeWriter) throws IOException {
        if (this.children.first == this.children.last && this.children.first instanceof Text) {
            int n = nodeWriter.getIndent();
            nodeWriter.setIndent(-1);
            nodeWriter.write(this.children.first);
            nodeWriter.setIndent(n);
        } else if (nodeWriter.getIndent() == -1) {
            Node node = this.children.first;
            while (node != null) {
                nodeWriter.write(node);
                node = node.next;
            }
        } else {
            nodeWriter.increaseIndent();
            Node node = this.children.first;
            while (node != null) {
                nodeWriter.writeEOL();
                nodeWriter.write(node);
                node = node.next;
            }
            nodeWriter.writeEOL();
            nodeWriter.decreaseIndent();
            nodeWriter.writeIndent();
        }
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getTagName() {
        return this.prefix == null ? this.name : this.prefix + ':' + this.name;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeObject(string) != null;
    }

    public String getAttribute(String string) {
        return this.getAttributeValue(string);
    }

    public Attr getAttributeNode(String string) {
        return this.getAttributeObject(string);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return this.getAttributeObject(string, string2);
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeObject(string, string2) != null;
    }

    public String getAttributeNS(String string, String string2) {
        return this.getAttributeValue(string, string2);
    }

    public org.w3c.dom.NodeList getElementsByTagName(String string) {
        NodeList nodeList = new NodeList();
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagName(string, nodeList);
        }
        return nodeList;
    }

    void addElementsByTagName(String string, NodeList nodeList) {
        if ("*".equals(string) || this.name.equals(string)) {
            nodeList.append(new Selection(this));
        }
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagName(string, nodeList);
        }
    }

    public org.w3c.dom.NodeList getElementsByTagNameNS(String string, String string2) {
        NodeList nodeList = new NodeList();
        if ("*".equals(string)) {
            Elements elements = this.getElements();
            while (elements.hasMoreElements()) {
                elements.next().addElementsByTagName(string2, nodeList);
            }
        } else {
            Elements elements = this.getElements();
            while (elements.hasMoreElements()) {
                elements.next().addElementsByTagNameNS(string, string2, nodeList);
            }
        }
        return nodeList;
    }

    void addElementsByTagNameNS(String string, String string2, NodeList nodeList) {
        if ("*".equals(string2) || this.name.equals(string2)) {
            if (string == null && this.namespace == null) {
                nodeList.append(new Selection(this));
            } else if (string != null && string.equals(this.namespace)) {
                nodeList.append(new Selection(this));
            }
        }
        Elements elements = this.getElements();
        while (elements.hasMoreElements()) {
            elements.next().addElementsByTagNameNS(string, string2, nodeList);
        }
    }

    public void removeAttributeNS(String string, String string2) {
        this.removeAttribute(string, string2);
    }

    public Attr removeAttributeNode(Attr attr) {
        ((Attribute)attr).remove();
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) {
        Attribute attribute = (Attribute)attr;
        attribute.resolve(this);
        Attribute attribute2 = (Attribute)this.attributes.first;
        while (attribute2 != null) {
            if (attribute2.hasName(attribute.namespace, attribute.name)) {
                this.attributes.replace(attribute2, attribute);
                return attribute2;
            }
            attribute2 = (Attribute)attribute2.next;
        }
        this.attributes.append(attribute);
        return null;
    }

    public Attr setAttributeNode(Attr attr) {
        return this.setAttributeNodeNS(attr);
    }

    public void setAttributeNS(String string, String string2, String string3) {
        String[] stringArray = Element.getParts(string2);
        Attribute attribute = this.getAttributeObject(string, stringArray[1]);
        if (attribute == null) {
            this.setAttribute(stringArray[0], stringArray[1], string3);
        } else {
            attribute.setPrefix(stringArray[0]);
            attribute.setValue(string3);
        }
    }

    public static String[] getParts(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return new String[]{string.substring(0, n), string.substring(n + 1)};
        }
        return new String[]{null, string};
    }
}

