/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.NodeTypeTest;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.tree.DOMExceptionImpl;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractNode
implements Node,
NodeInfo,
SourceLocator,
DOMLocator {
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public abstract boolean isSameNode(NodeInfo var1);

    public abstract String generateId();

    public abstract String getSystemId();

    public abstract String getBaseURI();

    public Node getOriginatingNode() {
        return this;
    }

    public abstract int compareOrder(NodeInfo var1);

    public abstract int getNameCode();

    public abstract int getFingerprint();

    public String getNodeName() {
        switch (this.getNodeType()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.getDisplayName();
            }
            case 2: {
                return this.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.getLocalName();
            }
            case 13: {
                return this.getLocalName();
            }
        }
        return "#unknown";
    }

    public abstract String getPrefix();

    public abstract String getURI();

    public String getDisplayName() {
        String string = this.getLocalName();
        if ("".equals(string)) {
            return "";
        }
        String string2 = this.getPrefix();
        if ("".equals(string2)) {
            return string;
        }
        return string2 + ":" + string;
    }

    public abstract String getLocalName();

    public abstract boolean hasChildNodes();

    public abstract boolean hasAttributes();

    public abstract String getAttributeValue(String var1, String var2);

    public abstract String getAttributeValue(int var1);

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public abstract AxisEnumeration getEnumeration(byte var1, NodeTest var2);

    public abstract NodeInfo getParent();

    public DocumentInfo getDocumentRoot() {
        NodeInfo nodeInfo = this;
        while (nodeInfo.getNodeType() != 9) {
            nodeInfo = nodeInfo.getParent();
        }
        return (DocumentInfo)nodeInfo;
    }

    public Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    public Node getPreviousSibling() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)11, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public Node getNextSibling() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)7, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public Node getFirstChild() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        if (axisEnumeration.hasMoreElements()) {
            return (Node)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public Node getLastChild() {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)3, AnyNodeTest.getInstance());
        NodeInfo nodeInfo = null;
        while (axisEnumeration.hasMoreElements()) {
            nodeInfo = axisEnumeration.nextElement();
        }
        return (Node)((Object)nodeInfo);
    }

    public Element getDocumentElement() {
        DocumentInfo documentInfo = this.getDocumentRoot();
        AxisEnumeration axisEnumeration = documentInfo.getEnumeration((byte)3, new NodeTypeTest(1));
        if (axisEnumeration.hasMoreElements()) {
            return (Element)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public void copyStringValue(Outputter outputter) throws TransformerException {
        outputter.writeContent(this.getStringValue());
    }

    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
    }

    public String getNodeValue() {
        switch (this.getNodeType()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.getStringValue();
            }
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    public NodeList getChildNodes() {
        try {
            return new NodeSetExtent(this.getEnumeration((byte)3, AnyNodeTest.getInstance()), (NodeOrderComparer)LocalOrderComparer.getInstance());
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public NamedNodeMap getAttributes() {
        if (this.getNodeType() == 1) {
            return new AttributeMap();
        }
        return null;
    }

    public Document getOwnerDocument() {
        return (Document)((Object)this.getDocumentRoot());
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node cloneNode(boolean bl) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public boolean supports(String string, String string2) {
        return this.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        String string = this.getURI();
        return string.equals("") ? null : string;
    }

    public void setPrefix(String string) throws DOMException {
        this.disallowUpdate();
    }

    protected void disallowUpdate() throws DOMException {
        throw new UnsupportedOperationException("The Saxon DOM cannot be updated");
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Element createElement(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String string) {
        return null;
    }

    public Comment createComment(String string) {
        return null;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr createAttribute(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)4, AnyNodeTest.getInstance());
        NodeSetExtent nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (nodeInfo.getNodeType() != 1 || !string.equals("*") && !string.equals(nodeInfo.getDisplayName())) continue;
            nodeSetExtent.append(nodeInfo);
        }
        return nodeSetExtent;
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)4, AnyNodeTest.getInstance());
        NodeSetExtent nodeSetExtent = new NodeSetExtent(LocalOrderComparer.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (nodeInfo.getNodeType() != 1 || !string.equals("*") && !string.equals(nodeInfo.getURI()) || !string2.equals("*") && !string2.equals(nodeInfo.getLocalName())) continue;
            nodeSetExtent.append(nodeInfo);
        }
        return nodeSetExtent;
    }

    public Element getElementById(String string) {
        return (Element)((Object)this.getDocumentRoot().selectID(string));
    }

    public String getTagName() {
        return this.getDisplayName();
    }

    public String getAttribute(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            String string2 = nodeInfo.getStringValue();
            if (string2 == null) {
                return "";
            }
            return string2;
        }
        return "";
    }

    public Attr getAttributeNode(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            return (Attr)((Object)nodeInfo);
        }
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public void removeAttribute(String string) throws DOMException {
        this.disallowUpdate();
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = this.getAttributeValue(string, string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        int n = this.getDocumentRoot().getNamePool().getFingerprint(string, string2);
        if (n == -1) {
            return null;
        }
        NameTest nameTest = new NameTest(2, n);
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, nameTest);
        if (axisEnumeration.hasMoreElements()) {
            return (Attr)((Object)axisEnumeration.nextElement());
        }
        return null;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String string) {
        AxisEnumeration axisEnumeration = this.getEnumeration((byte)2, AnyNodeTest.getInstance());
        while (axisEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo = axisEnumeration.nextElement();
            if (!nodeInfo.getDisplayName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeValue(string, string2) != null;
    }

    public String getData() {
        return this.getStringValue();
    }

    public void setData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public int getLength() {
        return this.getStringValue().length();
    }

    public String substringData(int n, int n2) throws DOMException {
        try {
            return this.getStringValue().substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public void insertData(int n, String string) throws DOMException {
        this.disallowUpdate();
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.disallowUpdate();
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.disallowUpdate();
    }

    public Text splitText(int n) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getValue() {
        return this.getStringValue();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    public Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            throw new UnsupportedOperationException("This method is defined only on attribute nodes");
        }
        return (Element)((Object)this.getParent());
    }

    public abstract short getNodeType();

    public abstract void copy(Outputter var1) throws TransformerException;

    public abstract String getStringValue();

    public abstract void setSystemId(String var1);

    private class AttributeMap
    implements NamedNodeMap {
        private AttributeMap() {
        }

        public Node getNamedItem(String string) {
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (!string.equals(nodeInfo.getDisplayName())) continue;
                return (Node)((Object)nodeInfo);
            }
            return null;
        }

        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = 0;
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (n2 == n) {
                    return (Node)((Object)nodeInfo);
                }
                ++n2;
            }
            return null;
        }

        public int getLength() {
            int n = 0;
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                axisEnumeration.nextElement();
                ++n;
            }
            return n;
        }

        public Node getNamedItemNS(String string, String string2) {
            if (string == null) {
                string = "";
            }
            AxisEnumeration axisEnumeration = AbstractNode.this.getEnumeration((byte)2, AnyNodeTest.getInstance());
            while (axisEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = axisEnumeration.nextElement();
                if (!string.equals(nodeInfo.getURI()) || !string2.equals(nodeInfo.getLocalName())) continue;
                return (Node)((Object)nodeInfo);
            }
            return null;
        }

        public Node setNamedItem(Node node) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        public Node removeNamedItem(String string) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }
    }

    private class DOMImplementationImpl
    implements DOMImplementation {
        private DOMImplementationImpl() {
        }

        public boolean hasFeature(String string, String string2) {
            return false;
        }

        public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }

        public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
            AbstractNode.this.disallowUpdate();
            return null;
        }
    }
}

