/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import bucket.util.PairType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.AbstractMasterDetailsMacro;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;

public class DetailsSummaryMacro
extends AbstractMasterDetailsMacro {
    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map map, String string, RenderContext renderContext) throws MacroException {
        String string2 = (String)map.get("label");
        String string3 = (String)map.get("headings");
        if (!TextUtils.stringSet((String)string2)) {
            return RenderUtils.blockError((String)"No 'label' value supplied for the details macro.", (String)this.renderErrorBody(string, renderContext));
        }
        if (!LabelUtil.isValidLabelName((String)string2)) {
            return RenderUtils.blockError((String)(GeneralUtil.escapeXml((String)string2) + " is not a valid label name"), (String)this.renderErrorBody(string, renderContext));
        }
        ContentEntityObject contentEntityObject = ((PageContext)renderContext).getEntity();
        if (!(contentEntityObject instanceof SpaceContentEntityObject)) {
            return RenderUtils.blockError((String)"Master view must be inside a space", (String)this.renderErrorBody(string, renderContext));
        }
        Label label = this.labelManager.getLabel(new Label(string2));
        Space space = ((SpaceContentEntityObject)contentEntityObject).getSpace();
        List list = this.labelManager.getCurrentContentForLabelAndSpace(label, space.getKey());
        Collections.sort(list);
        List list2 = this.getDetailsFromContent(list, string2, renderContext);
        Set set = this.getHeadingsFromHeadingsString(string3);
        if (set.size() == 0) {
            this.addAllHeadings(list2, set);
        }
        return this.renderTemplate(set, list2, string, renderContext);
    }

    private String renderTemplate(Set set, List list, String string, RenderContext renderContext) {
        Map map = MacroUtils.defaultVelocityContext();
        map.put("headings", set);
        map.put("details", list);
        try {
            return VelocityUtils.getRenderedTemplateWithoutSwallowingErrors((String)"/templates/extra/masterdetail/detailssummary.vm", (Context)new VelocityContext(map));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return RenderUtils.blockError((String)"System error: could not find template /templates/extra/masterdetail/detailssummary.vm", (String)this.renderErrorBody(string, renderContext));
        }
        catch (Exception exception) {
            return RenderUtils.blockError((String)("Unknown error drawing details summary: " + exception.getMessage()), (String)this.renderErrorBody(string, renderContext));
        }
    }

    private void addAllHeadings(List list, Set set) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DetailLine detailLine = (DetailLine)iterator.next();
            Set set2 = detailLine.getDetails().keySet();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                set.add(iterator2.next());
            }
        }
    }

    private Set getHeadingsFromHeadingsString(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (TextUtils.stringSet((String)string)) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                linkedHashSet.add(GeneralUtil.escapeXml((String)stringArray[i].trim()));
            }
        }
        return linkedHashSet;
    }

    private List getDetailsFromContent(List list, String string, RenderContext renderContext) {
        ArrayList<DetailLine> arrayList = new ArrayList<DetailLine>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ContentEntityObject contentEntityObject = (ContentEntityObject)iterator.next();
            String string2 = this.contentPropertyManager.getTextProperty(contentEntityObject, "masterdetail." + string);
            if (!TextUtils.stringSet((String)string2)) continue;
            PageContext pageContext = new PageContext(contentEntityObject, (PageContext)renderContext);
            List list2 = this.toDetails(string2, (RenderContext)pageContext);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                PairType pairType = (PairType)iterator2.next();
            }
            arrayList.add(new DetailLine(contentEntityObject, list2));
        }
        return arrayList;
    }

    public static class DetailLine {
        ContentEntityObject content;
        Map details;

        public DetailLine(ContentEntityObject contentEntityObject, List list) {
            this.content = contentEntityObject;
            this.details = new HashMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PairType pairType = (PairType)iterator.next();
                this.details.put(pairType.getKey(), pairType.getValue());
            }
        }

        public ContentEntityObject getContent() {
            return this.content;
        }

        public Map getDetails() {
            return this.details;
        }
    }
}

