/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.AbstractMasterDetailsMacro;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;

public class DetailsMacro
extends AbstractMasterDetailsMacro {
    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map map, String string, RenderContext renderContext) throws MacroException {
        List list;
        String string2 = (String)map.get("label");
        if (!TextUtils.stringSet((String)string2)) {
            return RenderUtils.blockError((String)"No 'label' value supplied for the details macro.", (String)this.renderErrorBody(string, renderContext));
        }
        if (!LabelUtil.isValidLabelName((String)string2)) {
            return RenderUtils.blockError((String)(GeneralUtil.escapeXml((String)string2) + " is not a valid label name"), (String)this.renderErrorBody(string, renderContext));
        }
        ContentEntityObject contentEntityObject = ((PageContext)renderContext).getEntity();
        if (!(contentEntityObject instanceof SpaceContentEntityObject)) {
            return RenderUtils.blockError((String)"Details can only be used on pages or blog posts", (String)this.renderErrorBody(string, renderContext));
        }
        if (!this.isAlreadyLabeled(contentEntityObject, string2)) {
            this.labelManager.addLabel(contentEntityObject, new Label(string2));
        }
        if ((list = this.toDetails(string, renderContext)).size() > 0) {
            this.contentPropertyManager.setTextProperty(contentEntityObject, "masterdetail." + string2, string);
        } else {
            this.contentPropertyManager.setTextProperty(contentEntityObject, "masterdetail." + string2, null);
        }
        if (!"true".equals(map.get("hidden"))) {
            return this.renderDetailsPanel(list, string, renderContext);
        }
        return "";
    }

    private String renderDetailsPanel(List list, String string, RenderContext renderContext) {
        Map map = MacroUtils.defaultVelocityContext();
        map.put("details", list);
        try {
            return VelocityUtils.getRenderedTemplateWithoutSwallowingErrors((String)"/templates/extra/masterdetail/details.vm", (Context)new VelocityContext(map));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return RenderUtils.blockError((String)"System error: could not find template /templates/extra/masterdetail/details.vm", (String)this.renderErrorBody(string, renderContext));
        }
        catch (Exception exception) {
            return RenderUtils.blockError((String)("Unknown error drawing details " + exception.getMessage()), (String)this.renderErrorBody(string, renderContext));
        }
    }

    private boolean isAlreadyLabeled(ContentEntityObject contentEntityObject, String string) {
        boolean bl = false;
        Iterator iterator = contentEntityObject.getLabels().iterator();
        while (iterator.hasNext()) {
            Label label = (Label)iterator.next();
            if (!Namespace.GLOBAL.equals((Object)label.getNamespace()) || !string.equals(label.getName())) continue;
            bl = true;
        }
        return bl;
    }
}

