/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BambooConfiguration
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$jira$web$action$BambooConfiguration == null ? (class$com$atlassian$jira$web$action$BambooConfiguration = BambooConfiguration.class$("com.atlassian.jira.web.action.BambooConfiguration")) : class$com$atlassian$jira$web$action$BambooConfiguration));
    public static final String SERVER_NAME_KEY = "bamboo.config.serverName";
    public static final String HOST_KEY = "bamboo.config.host";
    public static final String USERNAME_KEY = "bamboo.config.username";
    public static final String PASSWORD_KEY = "bamboo.config.password";
    private String serverName;
    private String host;
    private String username;
    private String password;
    private boolean viewMode;
    private ApplicationProperties properties;
    static /* synthetic */ Class class$com$atlassian$jira$web$action$BambooConfiguration;

    public BambooConfiguration(ApplicationProperties properties) {
        this.properties = properties;
    }

    public void doValidation() {
        if (StringUtils.isBlank((String)this.getServerName())) {
            this.addError("serverName", this.getText("A server name is required"));
        }
        if (StringUtils.isBlank((String)this.getHost())) {
            this.addError("host", "The address of your Bamboo instance is required");
        } else if (!this.getHost().startsWith("http://") && !this.getHost().startsWith("https://")) {
            this.addError("host", "The address of your Bamboo instance must start with http:// or https://");
        }
    }

    public String doEdit() throws Exception {
        this.setServerName(this.properties.getString(SERVER_NAME_KEY));
        this.setHost(this.properties.getString(HOST_KEY));
        this.setUsername(this.properties.getString(USERNAME_KEY));
        this.setPassword(this.properties.getString(PASSWORD_KEY));
        this.setViewMode(false);
        return "input";
    }

    public String doExecute() throws Exception {
        if (this.hasAnyErrors()) {
            this.setViewMode(false);
            return "input";
        }
        this.properties.setString(SERVER_NAME_KEY, this.getServerName());
        this.properties.setString(HOST_KEY, this.getHost());
        this.properties.setString(USERNAME_KEY, this.getUsername());
        this.properties.setString(PASSWORD_KEY, this.getPassword());
        this.setViewMode(true);
        return "success";
    }

    public String doView() throws Exception {
        if (this.isBambooConfigured()) {
            this.setServerName(this.properties.getString(SERVER_NAME_KEY));
            this.setHost(this.properties.getString(HOST_KEY));
            this.setUsername(this.properties.getString(USERNAME_KEY));
            this.setPassword(this.properties.getString(PASSWORD_KEY));
            this.setViewMode(true);
            return "success";
        }
        this.setViewMode(false);
        return "input";
    }

    private boolean isBambooConfigured() {
        return StringUtils.isNotBlank((String)this.properties.getString(SERVER_NAME_KEY));
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getHost() {
        if (this.host.endsWith("/")) {
            this.host = this.host.substring(0, this.host.length() - 1);
        }
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    public void setViewMode(boolean viewMode) {
        this.viewMode = viewMode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

