/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.portlets;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.ext.bamboo.portlets.BambooServer;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class StatusPortlet
extends PortletImpl {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$jira$plugin$ext$bamboo$portlets$StatusPortlet == null ? (class$com$atlassian$jira$plugin$ext$bamboo$portlets$StatusPortlet = StatusPortlet.class$("com.atlassian.jira.plugin.ext.bamboo.portlets.StatusPortlet")) : class$com$atlassian$jira$plugin$ext$bamboo$portlets$StatusPortlet));
    private static final int HTTP_STATUS_CODE_ERRORS = 400;
    private BambooServer bambooServer;
    static /* synthetic */ Class class$com$atlassian$jira$plugin$ext$bamboo$portlets$StatusPortlet;

    public StatusPortlet(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, ApplicationProperties applicationProperties) {
        super(jiraAuthenticationContext, permissionManager, applicationProperties);
        this.bambooServer = new BambooServer(applicationProperties);
    }

    protected Map getVelocityParams(PortletConfiguration portletConfiguration) {
        HashMap<String, String> params = new HashMap<String, String>();
        String resultHtml = "<strong><em>Error:</em></strong> could not retrieve information from Bamboo";
        try {
            params.put("servername", this.getServerName());
            String serverURL = this.getServerUrl();
            params.put("serverurl", serverURL);
            String summaryType = portletConfiguration.getProperty("summaryType");
            if (summaryType.equals("ALL")) {
                resultHtml = this.retrieveHtml(this.getAllUrl(serverURL));
                params.put("summarytype", "All Plans");
            } else {
                resultHtml = this.retrieveHtml(this.getFavouritesUrl(serverURL));
                params.put("summarytype", "Favourite Plans");
            }
            params.put("responseHtml", resultHtml);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        return params;
    }

    private String getAllUrl(String serverURL) {
        String url = serverURL + "/ajax/jsBuildSummaryAll.action" + "?os_username=" + this.bambooServer.getUserName() + "&os_password=" + this.bambooServer.getUserPassword();
        return url;
    }

    private String getFavouritesUrl(String serverURL) {
        String url = serverURL + "/ajax/jsBuildSummaryFavourites.action" + "?os_username=" + this.bambooServer.getUserName() + "&os_password=" + this.bambooServer.getUserPassword();
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveHtml(String url) {
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(url);
        String responseHtml = "<strong><em>Error:</em></strong> could not retrieve information from Bamboo";
        try {
            httpClient.executeMethod((HttpMethod)get);
            if (get.getStatusCode() >= 400) {
                responseHtml = "<h3>" + get.getStatusLine().toString() + "</h3>" + "<p>There was an error retrieving the builds.<br>\n" + "Please check your Bamboo server and/or your JIRA administration panel.</p>\n";
            } else {
                responseHtml = get.getResponseBodyAsString();
                String bambooContextPath = StatusPortlet.getContextPath(this.bambooServer.getHost());
                responseHtml = StatusPortlet.replaceContextPathWithFullPath(responseHtml, this.bambooServer.getHost(), bambooContextPath);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return responseHtml;
    }

    public static String getContextPath(String host) {
        String urlWithoutProtocol = host.substring(host.indexOf("//") + 2);
        if (urlWithoutProtocol.indexOf(47) >= 0) {
            return urlWithoutProtocol.substring(urlWithoutProtocol.indexOf(47));
        }
        return "";
    }

    public static String replaceContextPathWithFullPath(String s, String serverBaseUrl, String context) {
        if (serverBaseUrl.endsWith("/")) {
            serverBaseUrl = serverBaseUrl.substring(0, serverBaseUrl.length() - 1);
        }
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        s = s.replaceAll("src=\"" + context, "src=\"" + serverBaseUrl);
        s = s.replaceAll("href=\"" + context, "href=\"" + serverBaseUrl);
        return s;
    }

    private String getServerUrl() {
        String serverURL = this.bambooServer.getHost();
        return serverURL;
    }

    private String getServerName() {
        return this.bambooServer.getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

