/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo.portlets;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.ext.bamboo.portlets.BambooServer;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BuildGraphPortlet
extends PortletImpl {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$jira$plugin$ext$bamboo$portlets$BuildGraphPortlet == null ? (class$com$atlassian$jira$plugin$ext$bamboo$portlets$BuildGraphPortlet = BuildGraphPortlet.class$("com.atlassian.jira.plugin.ext.bamboo.portlets.BuildGraphPortlet")) : class$com$atlassian$jira$plugin$ext$bamboo$portlets$BuildGraphPortlet));
    private BambooServer bambooServer;
    static /* synthetic */ Class class$com$atlassian$jira$plugin$ext$bamboo$portlets$BuildGraphPortlet;

    public BuildGraphPortlet(JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, ApplicationProperties applicationProperties) {
        super(authenticationContext, permissionManager, applicationProperties);
        this.bambooServer = new BambooServer(applicationProperties);
    }

    protected Map getVelocityParams(PortletConfiguration portletConfiguration) {
        HashMap<String, String> params = new HashMap<String, String>();
        String plan = "";
        String graphType = "";
        String resultsFilter = "";
        String responseHtml = "";
        String heading = "";
        try {
            plan = portletConfiguration.getProperty("plan");
            graphType = portletConfiguration.getProperty("graphType");
            resultsFilter = portletConfiguration.getProperty("resultsFilter");
        }
        catch (Exception e) {
            responseHtml = "<strong><em>Error:</em></strong> could not find configuration information";
        }
        if (graphType.equals("byBuild")) {
            responseHtml = this.getBuildsChart(plan, resultsFilter);
            heading = "Build Duration & Number of Failures per Build";
        } else {
            responseHtml = this.getTimeChart(plan, resultsFilter);
            heading = "% Successful Builds &amp; Avg Duration per Time Period";
        }
        String filter = resultsFilter.replace('_', ' ');
        filter = filter.toLowerCase();
        params.put("filter", filter);
        params.put("responseHtml", responseHtml);
        params.put("plan", plan);
        params.put("planurl", this.bambooServer.getHost() + "/browse/" + plan);
        params.put("serverurl", this.bambooServer.getHost());
        params.put("servername", this.bambooServer.getName());
        params.put("heading", heading);
        return params;
    }

    private String getBuildsChart(String plan, String resultsFilter) {
        String serverURL = this.bambooServer.getHost();
        String graphURL = serverURL + "/js/viewCombinedByBuildNumberChart.action?buildKey=" + plan + "&filterController.selectedFilterKey=" + resultsFilter;
        String resultHtml = "<script language = \"JavaScript\" src = \"" + graphURL + "\"></script >";
        return resultHtml;
    }

    private String getTimeChart(String plan, String resultsFilter) {
        String serverURL = this.bambooServer.getHost();
        String graphURL = serverURL + "/js/jsViewCombinedByTimePeriodChart.action?buildKey=" + plan + "&filterController.selectedFilterKey=" + resultsFilter;
        String resultHtml = "<script language = \"JavaScript\" src = \"" + graphURL + "\"></script >";
        return resultHtml;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

