/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ext.bamboo;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.ext.bamboo.BambooBuildResultsAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.EasyList;
import com.opensymphony.user.User;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BambooBuildResultsTabPanel
extends AbstractIssueTabPanel {
    private static Logger log = Logger.getLogger((Class)(class$com$atlassian$jira$plugin$ext$bamboo$BambooBuildResultsTabPanel == null ? (class$com$atlassian$jira$plugin$ext$bamboo$BambooBuildResultsTabPanel = BambooBuildResultsTabPanel.class$("com.atlassian.jira.plugin.ext.bamboo.BambooBuildResultsTabPanel")) : class$com$atlassian$jira$plugin$ext$bamboo$BambooBuildResultsTabPanel));
    private static final int HTTP_STATUS_CODE_ERRORS = 400;
    private static final String ACTION_URL = "/ajax/build/viewBuildResultsByJiraKey.action";
    private static final String CSS_STYLING = "<style type=\"text/css\">\n    <!--\n        .bambooContent #Successful {\n            color: green;\n        }\n\n        .bambooContent #Failed {\n            color: red;\n        }\n\n        .bambooContent a.Failed {\n            color: red;\n        }\n\n        .bambooContent a.Successful {\n            color: green;\n        }\n        .bambooContent h1 {\n            font-size: 14px;\n        }\n    -->\n</style>\n\n";
    private static final String DIV_CLASS = "bambooContent";
    private static final String BEGIN_HTML = "<style type=\"text/css\">\n    <!--\n        .bambooContent #Successful {\n            color: green;\n        }\n\n        .bambooContent #Failed {\n            color: red;\n        }\n\n        .bambooContent a.Failed {\n            color: red;\n        }\n\n        .bambooContent a.Successful {\n            color: green;\n        }\n        .bambooContent h1 {\n            font-size: 14px;\n        }\n    -->\n</style>\n\n<div class=\"bambooContent\">";
    private static final String END_HTML = "<style type=\"text/css\">\n    <!--\n        .bambooContent #Successful {\n            color: green;\n        }\n\n        .bambooContent #Failed {\n            color: red;\n        }\n\n        .bambooContent a.Failed {\n            color: red;\n        }\n\n        .bambooContent a.Successful {\n            color: green;\n        }\n        .bambooContent h1 {\n            font-size: 14px;\n        }\n    -->\n</style>\n\n</div>";
    private ApplicationProperties properties;
    private PermissionManager permissionManager;
    static /* synthetic */ Class class$com$atlassian$jira$plugin$ext$bamboo$BambooBuildResultsTabPanel;

    public BambooBuildResultsTabPanel(PermissionManager permissionManager, ApplicationProperties properties) {
        this.permissionManager = permissionManager;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActions(Issue issue, User remoteUser) {
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(this.getBuildResultsUrl(issue));
        try {
            String responseHtml;
            httpClient.executeMethod((HttpMethod)get);
            if (get.getStatusCode() >= 400) {
                responseHtml = "<h1>" + get.getStatusLine().toString() + "</h1>" + "<p>There was an error retrieving the JIRA issue.<br>\n" + "Please check your Bamboo server and/or your JIRA administration panel.</p>\n";
            } else {
                responseHtml = get.getResponseBodyAsString();
                String bambooContextPath = BambooBuildResultsTabPanel.getContextPath(this.getHost());
                responseHtml = BambooBuildResultsTabPanel.replaceContextPathWithFullPath(responseHtml, this.getHost(), bambooContextPath);
            }
            List list = EasyList.build((Object)new BambooBuildResultsAction(BEGIN_HTML + responseHtml + END_HTML));
            return list;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            List list = EasyList.build((Object)new BambooBuildResultsAction(e.toString()));
            return list;
        }
        finally {
            get.releaseConnection();
        }
    }

    public boolean showPanel(Issue issue, User remoteUser) {
        return this.permissionManager.hasPermission(29, issue, remoteUser) && this.isBambooConfigured();
    }

    public static String getContextPath(String host) {
        String urlWithoutProtocol = host.substring(host.indexOf("//") + 2);
        if (urlWithoutProtocol.indexOf(47) >= 0) {
            return urlWithoutProtocol.substring(urlWithoutProtocol.indexOf(47));
        }
        return "";
    }

    public static String replaceContextPathWithFullPath(String s, String serverBaseUrl, String context) {
        if (serverBaseUrl.endsWith("/")) {
            serverBaseUrl = serverBaseUrl.substring(0, serverBaseUrl.length() - 1);
        }
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        s = s.replaceAll("src=\"" + context, "src=\"" + serverBaseUrl);
        s = s.replaceAll("href=\"" + context, "href=\"" + serverBaseUrl);
        return s;
    }

    private String getBuildResultsUrl(Issue issue) {
        return this.getHost() + ACTION_URL + "?os_username=" + this.getUsername() + "&os_password=" + this.getPassword() + "&jiraIssueKey=" + issue.getKey();
    }

    private boolean isBambooConfigured() {
        return StringUtils.isNotBlank((String)this.properties.getString("bamboo.config.serverName"));
    }

    private String getHost() {
        return this.properties.getString("bamboo.config.host");
    }

    private String getUsername() {
        return this.properties.getString("bamboo.config.username");
    }

    private String getPassword() {
        return this.properties.getString("bamboo.config.password");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

